/*------------------------------------------------------------------------------*
 * File Name: fu_utils.h	 													*
 * Creation: SIM																*
 * Purpose:  base class for filter of import file								*
 * Copyright (c) OriginLab Corp. 2006											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Hong 01/15/07 FIX_TREE_NODE_NOT_EXIST										*
 * Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD									*
 * Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE					*
 * Hong 03/12/07 QA80-9418-S1 ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT				*
 * Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE							*
 * Sim 03-19-2007 ADD_OPTION_TO_PARTIAL_COLUMN									*
 * Sim 03-20-2007 FIX_APPEND_COMMENT_WHEN_REIMPORT								*
 * Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE								*
 * Sim 04-06-2007 MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT							*
 *	Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT				*
 *	Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST				*
 *	Sim 04-30-2007 TEMP_FIX_IMPORT_MODE_FOR_SINGLE_FILE							*
 *	Sim 05-08-2007 REMOVE_REPLACE_OUT_OF_MULTI_FILE_IMPORT_MODE					*
 *	Sim 05-08-2007 ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE						*
 *	Sim 05-31-2007 IMPROVE_REIMPORT_CONTEXT_MENUE								*
 *	Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE							*
 *	Sim 06-06-2007 CHANGE_FILTER_TAGNAME_ISSUE									*
 *	Sim 06-07-2007 FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES						*
 *	Sim 06-08-2007 DEFAULT_VALUE_FOR_BIN_IMPORT									*
 *	Sim 06-26-2007 ADD_LOAD_DATA_FOLDER_FILTER									*
 *	Sim 08-06-2007 SUPPORT_SMART_SPARKLINE										*
 *	Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP	*
 *	Hong 08/15/07 v8.0682 PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING				*
 *	Hong 09/08/07 v8.0698b FIX_FAIL_DUMP_OUTPUT_RANGE_ORNG						*
 *	Sim 11-01-2007 CLEAN_RANGE_ID_CODE											*
 *	Hong 12/05/07 v8.0761 IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA						*
 *	Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME		*
 *	Hong 04/16/08 QA80-11397 CENTRALIZE_WITH_BETTER_LABEL_OF_RENAME_OPTIONS		*
 *	Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
 *	Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
 *	Sophy 10/23/2008 QA80-12422 SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER
 *	Sim 10-29-2008 v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING	*
 *	Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION				*
 *	Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
 *	Hong 01/09/09 v8.0995 CORRECT_IMPASC_ERROR_RETURN_CHECKING					*
 *	Hong 01/15/09 FIX_PCLAMP_PLOT_FAIL_HANDLE_TIME_OFFSET_OF_HOLDING_DURATION	*
 *	Folger 04/30/09 SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL
 *	Hong 11/10/09 QA80-11771 IMPORT_MODE_SUPPORT_SKIP_EMPTY_BOOK_SHEET			*
 *	Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
 *	Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC							*
 *	Sim 02-04-2010 QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE	*
 *	Hong 03/12/10 QA80-15192-P1 FIX_BINARY_FILTER_HAVE_DUPLICATE_ID_MAKE_COPY_VALUE_BY_IDS_FAIL
 *	Sim 04-27-2010 ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
 *	Folger 06/28/10 ORG-155 ASCII_IMPORT_SPEED_IMPROVE							*
 *	Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
 *------------------------------------------------------------------------------*/
 
#ifndef _FU_UTILS_
#define _FU_UTILS_

//#include <origin.h>
#include <oFilterUtils.h>
#include <..\originlab\impFilterID.h> ///---Sim 09-14-2006 REMOVE_DATA_ID_TO_SEPARATE_FILE

/// Hong 04/16/08 QA80-11397 CENTRALIZE_WITH_BETTER_LABEL_OF_RENAME_OPTIONS
/*******************Macro of Labels of Import XF Options**************************/
#define	STR_LBL_ADD_SPARKLINES			_L("Add Sparklines")
#define	STR_LBL_AUTO_SIZE				_L("Auto Resize Cells") ///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION

// Partial Options
#define	STR_LBL_PARTIAL_IMPORT			_L("Partial Import")

// Rename Options
#define	STR_LBL_RENAME_OPTIONS			_L("(Re)Naming Worksheet and Workbook")
///Sophy 6/12/2010 ORG-220-S4 NEW_RENAME_OPTIONS_FOR_IMPIMAGE
//#define	STR_LBL_AUTO_RENAME				_L("Auto Rename Using File Name")
#define	STR_LBL_AUTO_RENAME				_L("Auto Rename Using Filename")
///end NEW_RENAME_OPTIONS_FOR_IMPIMAGE
#define	STR_LBL_RENAME_SHEET			_L("Rename Sheet with (Partial) Filename")
#define	STR_LBL_RENAME_BOOK				_L("Rename Book with (Partial) Filename")
#define	STR_LBL_TRIM_FROM				_L("Trim Filename From")
#define	STR_LBL_TRIM_TO					_L("Trim Filename To")
#define	STR_LBL_LONG_NAME_ONLY			_L("Rename Long Name for Book only")
#define	STR_LBL_BOOK_INCLUDE_PATH		_L("Include File Path when Renaming Book")
#define	STR_LBL_APPEND_FNAME_TO_BKCMT	_L("Append Filename to Workbook Comment")
#define	STR_LBL_APPEND_FNAME_TO_COLCMT	_L("Append Filename to Column Comment")
#define	STR_LBL_APPEND_PATH_TO_FNAME	_L("Include File Path when Appending Filename")
///Sophy 6/12/2010 ORG-220-S4 NEW_RENAME_OPTIONS_FOR_IMPIMAGE
#define	STR_LBL_RENAME_MATRIX_OPTIONS	_L("(Re)Naming Matrix Sheet and Matrix Book")
#define	STR_LBL_RENAME_MATRIX_BOOK		_L("Rename Book with Filename")
#define	STR_LBL_RENAME_MATRIX_SHEET		_L("Rename Sheet with Filename")
///end NEW_RENAME_OPTIONS_FOR_IMPIMAGE
/// end CENTRALIZE_WITH_BETTER_LABEL_OF_RENAME_OPTIONS

#define		GUI_SHOW_NICE_NAME /// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR

///Sophy 9/21/2009 SET_LABEL_ON_GUI_FOR_TRANSLATION
#define	STR_FILE_INFO			_L("File Info")
#define	STR_DATA_SELECTION		_L("Data Selection")
///end SET_LABEL_ON_GUI_FOR_TRANSLATION
///---Sim 09-14-2006 REMOVE_DATA_ID_TO_SEPARATE_FILE
/*
// filter structure
///---Sim 08-29-2006 ADD_DISP_STRUCTURE
#define MAX_SIZE_COL_DESIGN		200
#define MAX_SIZE_COL_FORMATS	200
#define MAX_SIZE_PLOT_TEMPL		80
#define MAX_SIZE_PAGE_TEMPL		80
#define MAX_SIZE_FILE_SPEC		80
#define MAX_SIZE_DESCRIPTION	100

typedef struct tagDISPIMP {
	//double _id(IDE_DISP_IMP_ORIGINVER)		dOriginVer;// Hong 9/01/06 MOVE_TO_FIRST_LEVEL 
	//int _id(IDE_DISP_IMP_TYPE)				iType;// Hong 9/01/06 MOVE_TO_FIRST_LEVEL
	int _id(IDE_DISP_IMP_RANGETOGRAPH)		iApplyRangeToGraph;
	int _id(IDE_DISP_IMP_LINKWKS)			iLinkWks;
	//char _id(IDE_DISP_IMP_COLDESIGN)		ColDesignations[MAX_SIZE_COL_DESIGN];
	string _id(IDE_DISP_IMP_COLDESIGN)		strColDesignations;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	int _id(IDE_DISP_IMP_COLDESIGNREP)		iColDesignationsRepetitive;
	//char _id(IDE_DISP_IMP_COLFORMATS)		ColFormats[MAX_SIZE_COL_FORMATS];
	string _id(IDE_DISP_IMP_COLFORMATS)		strColFormats;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	int _id(IDE_DISP_IMP_PLOTTYPE)			iPlotType;
	//char _id(IDE_DISP_IMP_PLOTTEMPLATE)	PlotTemplate[MAX_SIZE_PLOT_TEMPL];
	string _id(IDE_DISP_IMP_PLOTTEMPLATE)	strPlotTemplate;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	int _id(IDE_DISP_IMP_PAGETYPE)			iTargetWindowType;
	//char _id(IDE_DISP_IMP_PAGETEMPLATE)	TargetWindowTemplate[MAX_SIZE_PAGE_TEMPL];
	string _id(IDE_DISP_IMP_PAGETEMPLATE)	strTargetWindowTemplate;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	int _id(IDE_DISP_IMP_FNAMETOWKSLAB)		strFilenameToWksLabel;
	//char _id(IDE_DISP_IMP_FILESPEC)		FileSpec[MAX_SIZE_FILE_SPEC];
	string _id(IDE_DISP_IMP_FILESPEC)		strFileSpec;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
	//char _id(IDE_DISP_IMP_DESCRIPTION)	Description[MAX_SIZE_DESCRIPTION];
	string _id(IDE_DISP_IMP_DESCRIPTION)	strDescription;//Hong 8/31/06 CONVERT_CHAR_ARRAY_TO_STRING
} DISPIMP;
///---END ADD_DISP_STRUCTURE

///---Sim 08-29-2006 ADD_BINARY_STRUCTURE
typedef struct tagBINIMP {
	int _id(IDE_BINIMP_HEADERBYTES)		iHeaderBytes;				//number of bytes for header
	int _id(IDE_BINIMP_AUTOCOLTYPES)	iAutoColTypes;				//indicate if set col type explicitly
	int _id(IDE_BINIMP_NUMCOLUMNS)		iNumColumns;				//number of columns
	int _id(IDE_BINIMP_PARTIAL)			iPartial;					//indicate partial data will be read from the file
	int _id(IDE_BINIMP_PARTIALC1)		iPartialC1;					//partial reading start column number, 0 based, include this column
	int _id(IDE_BINIMP_PARTIALC2)		iPartialC2;					//partial reading end column number, this column will not be included
	int _id(IDE_BINIMP_PARTIALR1)		iPartialR1;					//partial reading start row number, 0 based, this row will be included
	int _id(IDE_BINIMP_PARTIALR2)		iPartialR2;					//partial reading end row number, this row will not be included
	int _id(IDE_BINIMP_RENAMEWKS)		iRenameWks;					//if rename worksheet name to the file name
	int _id(IDE_BINIMP_BIGENDIAN)		iBigEndian;					//numeric value byte order, use big endian if TRUE
	int _id(IDE_BINIMP_APPLYRANGE)		iApplyRange;				//
	int _id(IDE_BINIMP_MODE)			iMode;						// Data destination in worksheet. See ASCIMP_MODE_* constants in OC_Types.h
	int _id(IDE_BINIMP_SKIPROWS)		iSkipRows;					// number of data rows to skip for each row of data read
	int _id(IDE_BINIMP_READROWS)		iReadRows;
	vector<BYTE> _id(IDE_BINIMP_PARAMTYPE)	vParamType;		//data type for each column
	vector<WORD> _id(IDE_BINIMP_PARAMSIZE)	vParamSize;		//size of the data type for each column, bytes
	vector<WORD> _id(IDE_BINIMP_PARAMCOUNT)	vParamCount;		//number of consective columns with same data type
	DWORD _id(IDE_BINIMP_FLAGS)			flags; /// EJP 07-21-2004 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
} BINIMP;
///---END ADD_BINARY_STRUCTURE

///Hong 8/29/06 ADD_XF_STRUCTURE
typedef enum {
	IDE_XFIMP_NAME				= 0x00000400,
	IDE_XFIMP_OPENSETTING		= 0x00000401,
}IDE_XFIMP_ID;

#define IDE_XFIMP_IMPORTMODE		IDE_IMP_IMPORTMODE
/// Hong 9/11/06 MORE_FOR_XF_FILTER
#define IDE_XFIMP_RENAMEWKS			IDE_IMP_RENAMEWKS
#define IDE_XFIMP_FLAGS				IDE_IMP_FLAGS
/// end MORE_FOR_XF_FILTER
typedef struct tagXFIMP {
	/// Hong 9/11/06 MORE_FOR_XF_FILTER
	int 	_id(IDE_XFIMP_RENAMEWKS)		iRenameWks;		//if rename worksheet name to the file name
	DWORD 	_id(IDE_XFIMP_FLAGS)			flags; 			/// EJP 07-21-2004 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
	/// end MORE_FOR_XF_FILTER
	string 	_id(IDE_XFIMP_NAME)		 		strName;
	bool   	_id(IDE_XFIMP_OPENSETTING) 		bOpenSetting;
	int 	_id(IDE_XFIMP_IMPORTMODE) 		iMode;
} XFIMP;
///end ADD_XF_STRUCTURE

///---Sim 08-30-2006 ADD_USERDEFINE_STRUCTURE
typedef enum {
}IDE_USERDEFIMP_ID;

#define IDE_USERDEFIMP_POSTIMPSCRIPT	IDE_IMP_POSTIMPSCRIPT
#define IDE_USERDEFIMP_FILE				IDE_IMP_FILE
#define IDE_USERDEFIMP_FUNCTION			IDE_IMP_FUNCTION
#define IDE_USERDEFIMP_CLASS			IDE_IMP_CLASS

#define MAX_SIZE_POSTIMPSCRIPT		200
#define MAX_SIZE_FILE				80
#define MAX_SIZE_FUNCTION			80
#define MAX_SIZE_CLASS				80

typedef struct tagUSERDEFIMP {
	char 	_id(IDE_USERDEFIMP_POSTIMPSCRIPT) 	PostImportScript[MAX_SIZE_POSTIMPSCRIPT];
	char 	_id(IDE_USERDEFIMP_FILE) 			OCFile[MAX_SIZE_FILE];
	char 	_id(IDE_USERDEFIMP_FUNCTION) 		OCFunction[MAX_SIZE_FUNCTION];
	char 	_id(IDE_USERDEFIMP_CLASS) 			OCClass[MAX_SIZE_CLASS];
} USERDEFIMP;
///---END ADD_USERDEFINE_STRUCTURE

///---Sim 08-29-2006 ADD_VAR_STRUCTURE
typedef enum {
	IDE_VARIMP_VARIABLES_NODE	= 0x00000450,
	IDE_VARIMP_VARS_NODE		= 0x00000451,
	IDE_VARIMP_EXTVARBYSCAN		= 0x00000452,
	IDE_VARIMP_PAGEINFO			= 0x00000453,
	IDE_VARIMP_EXTBYDELIMITER	= 0x00000454,
	IDE_VARIMP_EXTBYPOSITION	= 0x00000455,
	IDE_VARIMP_EXTBYOCFUNC		= 0x00000456,
	IDE_VARIMP_OCFILENAME		= 0x00000457,
	IDE_VARIMP_OCFUNCNAME		= 0x00000458,
}IDE_VARIMP_ID;
typedef struct tagVARIMP {
	int 	_id(IDE_VARIMP_EXTVARBYSCAN) 		ExtractByScanning;
	int 	_id(IDE_VARIMP_PAGEINFO) 			PageInfo;
	int 	_id(IDE_VARIMP_EXTBYDELIMITER)		ExtractByDelimiter;
	int 	_id(IDE_VARIMP_EXTBYPOSITION)		ExtractByPosition;
	int 	_id(IDE_VARIMP_EXTBYOCFUNC)			ExtractByOCFunction;
	int 	_id(IDE_VARIMP_OCFILENAME)			OCFileName;
	int 	_id(IDE_VARIMP_OCFUNCNAME)			OCFunctionName;
} VARIMP;
///---END ADD_VAR_STRUCTURE

///---Sim 08-30-2006 ADD_DRAGNDROP_STRUCTURE
typedef enum {
	IDE_DNDIMP_GRAPH		= 0x00000500,
	IDE_DNDIMP_WORKSPACE	= 0x00000501,
}IDE_DNDIMP_ID;
typedef struct tagDNDIMP {
	int 	_id(IDE_DNDIMP_GRAPH) 		Graph;
	int 	_id(IDE_DNDIMP_WORKSPACE)	Workspace;
} DNDIMP;
///---END ADD_DRAGNDROP_STRUCTURE
/// Hong 9/01/06 ADD_DATAID_FOR-PARAMS
typedef enum{
	IDE_PARAMSIMP_HEADERPARAMETERS_NODE	= 0x00000550,
///---Sim 09-05-2006 MORE_ADDITION
	IDE_PARAMSIMP_FIRSTLINE				= 0x00000551,
	IDE_PARAMSIMP_LASTLINE				= 0x00000552,
	IDE_PARAMSIMP_SEPARATOR				= 0x00000553,
	IDE_PARAMSIMP_NAME					= 0x00000554,
	IDE_PARAMSIMP_TYPE					= 0x00000555,
	IDE_PARAMSIMP_LINE					= 0x00000556,
	IDE_PARAMSIMP_POS					= 0x00000557,
	IDE_PARAMSIMP_END					= 0x00000558,
	IDE_PARAMSIMP_OFFSET				= 0x00000559,
	IDE_PARAMSIMP_SIZE					= 0x00000560,
///---END MORE_ADDITION
}IDE_PARAMSIMP_ID;
///---Sim 09-05-2006 MORE_ADDITION
typedef struct tagPARAMSIMPRoot {
	int 	_id(IDE_PARAMSIMP_FIRSTLINE)	FirstLine;
	int 	_id(IDE_PARAMSIMP_LASTLINE)		LastLine;
	int 	_id(IDE_PARAMSIMP_SEPARATOR)	Separator;
} PARAMSIMPRoot;

typedef struct tagPARAMSIMP {
	string 	_id(IDE_PARAMSIMP_NAME) 		Name;
	int 	_id(IDE_PARAMSIMP_TYPE)			Type;
	int 	_id(IDE_PARAMSIMP_LINE)			Line;
	int 	_id(IDE_PARAMSIMP_POS)			Pos;
	int 	_id(IDE_PARAMSIMP_END)			End;
	int 	_id(IDE_PARAMSIMP_OFFSET)		Offset;
	int 	_id(IDE_PARAMSIMP_SIZE)			Size;
} PARAMSIMP;
///---END MORE_ADDITION
/// end ADD_DATAID_FOR-PARAMS

///---Sim 09-04-2006 ADD_HEADER_STRUCTURE
typedef enum{
	IDE_HEADERIMP_HEADER_NODE		= 0x00000600,
	IDE_HEADERIMP_SAVEFIRSTLINE 	= 0x00000601,
	IDE_HEADERIMP_SAVENUMLINES		= 0x00000602,
}IDE_HEADERIMP_ID;
///---END ADD_HEADER_STRUCTURE
*/
///---END REMOVE_DATA_ID_TO_SEPARATE_FILE

// iw_base
enum {
	IMPERR_NONE = 0,
	IMPERR_NO_FILTER,
	IMPERR_LOAD_FILTER,
	IMPERR_NO_TARGET_PAGE,
	IMPERR_GET_IMPORT_FUNC,
	IMPERR_IMPORT_FUNC_ERR,
	IMPERR_PREPARE_WKS,
	IMPERR_IMPORT_MODE, ///---Sim 07-31-2006 ERR_HANDLE
	IMPERR_FILTER_TYPE,
	IMPERR_CANCEL_ON_LOCKED_COL,
	IMPERR_NO_DATA_FILE, /// EJP 2005-10-26 v8.0324 Qa70-7921 XFUNC_TO_IMPORT_FILES
	IMPERR_TARGET_PAGE_TYPE, /// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
	IMP_USER_CANCEL, /// Sim 07-28-2006 MORE_CODE
	IMP_IMPWIZ,	///---Sim 01-04-2007 SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
	IMPERR_IWCLASS_UNDEFINED, /// AW 
	IMPERR_UNSUUPORT_PAGE_TYPE, ///AW
	IMPERR_WKS_HAS_COL_LOCKED, /// Hong 01/09/09 v8.0995 CORRECT_IMPASC_ERROR_RETURN_CHECKING
	IMPERR_FORCE_ASCII_FILTER,	///------ Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
};

enum {
	FILTER_DDGRAPH_OPENONLY = 0,
	FILTER_DDGRAPH_PLOT,
	FILTER_DDGRAPH_PLOTSETTINGS
};
#define IS_FILTER_DDGRAPH(i) (FILTER_DDGRAPH_OPENONLY <= (i) && (i) <= FILTER_DDGRAPH_PLOTSETTINGS)

enum {
	FILTER_DDWORKSPACE_OPENONLY = 0,
	FILTER_DDWORKSPACE_PLOT_1LAYER,
	FILTER_DDWORKSPACE_PLOT_MULTILAYER,
	FILTER_DDWORKSPACE_PLOT_MULTIWINDOW
};
#define IS_FILTER_DDWORKSPACE(i) (FILTER_DDWORKSPACE_OPENONLY <= (i) && (i) <= FILTER_DDWORKSPACE_PLOT_MULTIWINDOW)
/// Hong 08/15/07 v8.0682 PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING
// move to oc_sys.h for more general place
//#define	IMPORT_FILTER_EXTENSION_WILD			"*.oif"
//#define	FILTERS_FOLDER_NAME						"Filters\\"
/// end PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING

#define IFF_TARGET_PAGE_TYPE	0x0001

///---Sim 08-29-2006 GET_FILTER_BY_ID
//#define fuGetType(_tn)			fuGetInt(&_tn, IDE_FLT_TYPE, FILTER_TYPE_UNKNOWN)
#define fuGetType(_tn)				fuGetInt(_tn, IDE_DISP_IMP_TYPE, FILTER_TYPE_UNKNOWN)
#define fuSetType(_tn, _nType)		fuSetInt(_tn, IDE_DISP_IMP_TYPE, _nType)

///---Sim 01-31-2007 ADD_AUTO_RENAME
#define fuIsAutoRename(_tn)			fuGetInt(_tn, IDE_DISP_IMP_AUTO_RENAME, FALSE)
#define fuSetAutoRename(_tn, _nVal)			fuSetInt(_tn, IDE_DISP_IMP_AUTO_RENAME, _nVal)
///---END ADD_AUTO_RENAME

//#define fuIsRenameWks(_tn)		fuGetInt(&_tn, IDE_FLT_REN_WKS, FALSE)
#define fuIsRenameWks(_tn)			fuGetInt(_tn, IDE_IMP_RENAMEWKS, FALSE)

/// Hong 9/11/06 ERROR_GET_RENAME_WORKBOOK
/*
//#define fuIsRenameWorkbook(_tn)	fuGetFlag(&_tn, AI_FLAG_FNAME_TO_WKBK_NAME, FALSE)
#define fuIsRenameWorkbook(_tn)		fuGetInt(_tn, IDE_DISP_IMP_FNAMETOWKSLAB, FALSE)
*/
#define fuIsRenameWorkbook(_tn)		fuGetFlag(_tn, AI_FLAG_FNAME_TO_WKBK_NAME, FALSE)
#define fuSetRenameWorkbook(_tn, _bVal)	fuSetFlag(_tn, AI_FLAG_FNAME_TO_WKBK_NAME, _bVal) ///---Sim 01-29-2007 MORE_UTILS_FUNCTION
/// end ERROR_GET_RENAME_WORKBOOK

///---Sim 01-29-2007 MORE_UTILS_FUNCTION
#define fuXFIsRenameWorkbook(_tn)		fuGetInt(_tn, IDE_IMP_FILENAME2WKBK, FALSE)
#define fuXFSetRenameWorkbook(_tn, _bVal)		fuSetInt(_tn, IDE_IMP_FILENAME2WKBK, _bVal)
///---END MORE_UTILS_FUNCTION

///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
#define fuIsRenameBookLongNameOnly(_tn)			fuGetFlag(_tn, AI_FLAG_FNAME_TO_WKBK_LONG_NAME_ONLY, FALSE)
#define fuSetRenameBookLongNameOnly(_tn, _bVal)			fuSetFlag(_tn, AI_FLAG_FNAME_TO_WKBK_LONG_NAME_ONLY, _bVal)

#define fuXFIsRenameBookLongNameOnly(_tn)		fuGetInt(_tn, IDE_IMP_WKBKLNONLY, FALSE)
#define fuXFSetRenameBookLongNameOnly(_tn, _bVal)		fuSetInt(_tn, IDE_IMP_WKBKLNONLY, _bVal)
///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME


///---Sim 02-25-2007 MORE_UTILS_FUNCTION
#define fuIsRenameBookWithoutPath(_tn)			fuGetFlag(_tn, AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME, FALSE)
#define fuSetRenameBookWithoutPath(_tn, _bVal)			fuSetFlag(_tn, AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME, _bVal)

#define fuXFIsRenameBookIncludePath(_tn)		fuGetInt(_tn, IDE_IMP_ADDPATH4WKBK, FALSE)
#define fuXFSetRenameBookIncludePath(_tn, _bVal)		fuSetInt(_tn, IDE_IMP_ADDPATH4WKBK, _bVal)
///---END MORE_UTILS_FUNCTION

//#define fuGetOriginVersion(_tn)	fuGetDouble(&_tn, IDE_FLT_ORIGIN_VER, 7.5)
#define fuGetOriginVersion(_tn)		fuGetDouble(_tn, IDE_DISP_IMP_ORIGINVER, 7.5)

//#define fuGetImportMode(_tn)		fuGetInt(&_tn, IDE_FLT_IMPORT_MODE, ASCIMP_MODE_REPLACE_DATA)
//#define fuGetImportMode(_tn)		fuGetInt(_tn, IDE_IMP_IMPORTMODE, ASCIMP_MODE_REPLACE_DATA)

//#define fuGetPlotID(_tn)			fuGetInt(&_tn, IDE_FLT_PLOT_TYPE, IDM_PLOT_LINE)
#define fuGetPlotID(_tn)			fuGetInt(_tn, IDE_DISP_IMP_PLOTTYPE, IDM_PLOT_LINE)
#define fuSetPlotID(_tn, _nVal)				fuSetInt(_tn, IDE_DISP_IMP_PLOTTYPE, _nVal)

/// AW 08/18/06 SUPPORT_XF_OPTION_SETTING
// I did not use the first way as it need change VC level
//#define fuGetXFSetting(_tn)			fuGetInt(&_tn, IDE_FLT_XF_SETTING, 0) /// AW 08/18/06 SUPPORT_XF_OPTION_SETTING
//#define fuGetXFSetting(_tn) 	_tn.Common.bOpenSetting ? _tn.Common.bOpenSetting.nVal : 0;
#define fuGetXFSetting(_tn) 	fuGetInt(_tn, IDE_XFIMP_OPENSETTING, 0)
/// END SUPPORT_XF_OPTION_SETTING

///---Sim 05-08-2007 ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE
int fuGet1stImportMode(TreeNode& trFilter);
void fuSet1stImportMode(TreeNode& trFilter, int iImportMode);
///---END ADD_OPTIONS_FOR_IMPORT_MODE_OF_1ST_FILE
int fuGetImportMode(TreeNode& trFilter);
void fuSetImportMode(TreeNode& trFilter, int iImportMode);

//TreeNode fuGetHeaderParams(TreeNode &trFilter); ///---Sim 06-08-2007 DUPLICATE_FUNC_DECLARATION
/// Hong 9/15/06 FIX_TREE_NODE_NOT_EXIST
BOOL fuSetExtractVarByScanning(TreeNode& tnFilter, BOOL bEnable);
//#define fuSetExtractVarByScanning(_tnFilter, _bEnable)		fuSetInt(_tnFilter, IDE_VARIMP_EXTVARBYSCAN, _bEnable)
/// end FIX_TREE_NODE_NOT_EXIST
BOOL fuSetOriginVersion(TreeNode &tnFilter);
bool _fuLoadFilter(TreeNode &tnFilter, LPCSTR lpcszFile);
///---Sim 06-26-2007 ADD_LOAD_DATA_FOLDER_FILTER
//bool fuLoad(TreeNode &tnFilter, LPCSTR lpcszFile=NULL);
/// Hong 03/12/10 QA80-15192-P1 FIX_BINARY_FILTER_HAVE_DUPLICATE_ID_MAKE_COPY_VALUE_BY_IDS_FAIL
//bool fuLoad(TreeNode &tnFilter, LPCSTR lpcszFile=NULL, LPCSTR lpcszDefPath = NULL);
bool fuLoad(TreeNode &tnFilter, LPCSTR lpcszFile=NULL, LPCSTR lpcszDefPath = NULL, BOOL bCheckAddRepeatID = true);
/// end FIX_BINARY_FILTER_HAVE_DUPLICATE_ID_MAKE_COPY_VALUE_BY_IDS_FAIL
///---END ADD_LOAD_DATA_FOLDER_FILTER
bool fuGetTypeName(TreeNode &trFilter, string &strType);
///---END GET_FILTER_BY_ID

int ImportErrorMsgBox(int iErr, LPCSTR lpcszFilter=NULL);
//int _is_sheet_empty(Layer &ly); /// Sim 08-25-2006 COMMON_FUNC_WKS_EMPTY

///---Sim 08-30-2006 REMOVE_FROM_OFILTERUTILS
//// AW 02/27/06 GET_VALID_TEMPLATE_FILE
//int fuGetTargetPage(const TreeNode& tnFilter, string& strTemplate = NULL);
int fuGetTargetPage(const TreeNode& tnFilter, string& strTemplate = NULL, string& strDataFilePath = NULL);
//// END GET_VALID_TEMPLATE_FILE
BOOL fuSetTargetPage(TreeNode& tnFilter, int nType, LPCSTR lpcszTemplate = NULL);
///---END REMOVE_FROM_OFILTERUTILS


// impwiz
///---Sim 08-29-2006 GET_FILTER_BY_ID
//#define fuIsAppendFileNameToWorkBookComments(_tn)	fuGetFlag(&_tn, AI_FLAG_FNAME_TO_WKBK_COMMENTS, FALSE)
#define fuIsAppendFileNameToWorkBookComments(_tn)	fuGetFlag(_tn, AI_FLAG_FNAME_TO_WKBK_COMMENTS, FALSE)
#define fuSetAppendFileNameToWorkBookComments(_tn, _bVal)	fuSetFlag(_tn, AI_FLAG_FNAME_TO_WKBK_COMMENTS, _bVal) ///---Sim 01-29-2007 MORE_UTILS_FUNCTION
///---Sim 01-29-2007 MORE_UTILS_FUNCTION
#define fuXFIsAppendFileNameToWorkBookComments(_tn)		fuGetInt(_tn, IDE_IMP_FILENAME2WKBKCOMMENT, FALSE)
#define fuXFSetAppendFileNameToWorkBookComments(_tn, _bVal)	fuSetInt(_tn, IDE_IMP_FILENAME2WKBKCOMMENT, _bVal)
///---END MORE_UTILS_FUNCTION
//#define fuIsAppendFileNameWithoutPath(_tn)		fuGetFlag(&_tn, AI_FLAG_REMOVE_FNAME_PATH, FALSE)
#define fuIsAppendFileNameWithoutPath(_tn)			fuGetFlag(_tn, AI_FLAG_REMOVE_FNAME_PATH, FALSE)
#define fuSetAppendFileNameWithoutPath(_tn, _bVal)			fuSetFlag(_tn, AI_FLAG_REMOVE_FNAME_PATH, _bVal) ///---Sim 01-29-2007 MORE_UTILS_FUNCTION
///---Sim 01-29-2007 MORE_UTILS_FUNCTION
#define fuXFIsAppendFileNameIncludePath(_tn)		fuGetInt(_tn, IDE_IMP_ADDPATH, FALSE)
#define fuXFSetAppendFileNameIncludePath(_tn, _bVal)		fuSetInt(_tn, IDE_IMP_ADDPATH, _bVal)
///---END MORE_UTILS_FUNCTION

BOOL fuGetVarsRoot(TreeNode& tnFilter, TreeNode& tnVarsRoot);
//BOOL fuIsVarInPageInfo(TreeNode& tnFilter);
#define fuIsVarInPageInfo(_tn)						fuGetInt(_tn, IDE_VARIMP_PAGEINFO, FALSE)
bool fuGetPostImportScript(TreeNode &trFilter, string &strScript);
//string fuGetDesignations(TreeNode& trFilter);
#define fuGetDesignations(_tn) 						fuGetStr(_tn, IDE_DISP_IMP_COLDESIGN, "")
#define fuSetDesignations(_tn, _lpcstr)		fuSetStr(_tn, IDE_DISP_IMP_COLDESIGN, _lpcstr)
//string fuGetFormats(TreeNode& trFilter);
#define fuGetFormats(_tn)							fuGetStr(_tn, IDE_DISP_IMP_COLFORMATS, "")
#define fuSetFormats(_tn, _lpcstr)			fuSetStr(_tn, IDE_DISP_IMP_COLFORMATS, _lpcstr)
//BOOL fuGetRepetitive(TreeNode& trFilter);
#define fuGetRepetitive(_tn)						fuGetInt(_tn, IDE_DISP_IMP_COLDESIGNREP, FALSE)
#define fuSetRepetitive(_tn,_b)			fuSetInt(_tn, IDE_DISP_IMP_COLDESIGNREP, _b)
///---END GET_FILTER_BY_ID

/// AW 09/20/06 QA80-8988 MORE_ON_XF
#define fuGetShowTime(_tn)				fuGetInt(_tn, IDE_XFIMP_OPSHOWTIME, FALSE)
#define fuSetShowTime(_tn,_b)			fuSetInt(_tn, IDE_XFIMP_OPSHOWTIME, _b)
/// Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
//#define fuGetSparkLine(_tn)				fuGetInt(_tn, IDE_XFIMP_OPSPARKLINES, FALSE)
//#define fuSetSparkLine(_tn,_b)			fuSetInt(_tn, IDE_XFIMP_OPSPARKLINES, _b)
#define fuGetSparkLine(_tn)				fuGetInt(_tn, IDE_DISP_IMP_SPARKLINES, FALSE)
#define fuSetSparkLine(_tn,_b)			fuSetInt(_tn, IDE_DISP_IMP_SPARKLINES, _b)
/// end ADD_SPARKLINE_TO_IMPORT_WIZARD
/// END QA80-8988 MORE_ON_XF

/// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
#define	fuIsNotSaveImportInfoToPage(_tn)			fuGetFlag(_tn, AI_FLAG_NO_IMPORT_INFO_TO_PAGE, TRUE)
#define	fuSetNotSaveImportInfoToPage(_tn, _bVal)	fuSetFlag(_tn, AI_FLAG_NO_IMPORT_INFO_TO_PAGE, _bVal)
/// end ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED

///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
enum{
	FILTER_AUTO_SIZE_NO,
	FILTER_AUTO_SIZE_WIDTH,
	FILTER_AUTO_SIZE_HEIGHT,
	FILTER_AUTO_SIZE_WIDTH_HEIGHT,
};
#define STR_COMBO_AUTO_SIZE		_L("No|Width|Height|Width and Height")

#define fuGetAutoSize(_tn)				fuGetInt(_tn, IDE_DISP_IMP_AUTOSIZE, FILTER_AUTO_SIZE_NO)
#define fuSetAutoSize(_tn, _nVal)		fuSetInt(_tn, IDE_DISP_IMP_AUTOSIZE, _nVal)
///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION

// IWASCII
#define _MSG_INT(str, v)
BOOL fuGetASCIMP(TreeNode& trFilter, ASCIMP& ascimp, BOOL bGetCommonNode = FALSE);
BOOL fuGetCustomDate(TreeNode& tnFilter, string& strFormat);
///Hong 08-28-2006 REMOVE_TO_OC_TYPE
/*
// IWBinary
typedef struct tagBINIMP {
	int iHeaderBytes;				//number of bytes for header
	int iAutoColTypes;				//indicate if set col type explicitly
	int iNumColumns;				//number of columns
	int iPartial;					//indicate partial data will be read from the file
	int iPartialC1;					//partial reading start column number, 0 based, include this column
	int iPartialC2;					//partial reading end column number, this column will not be included
	int iPartialR1;					//partial reading start row number, 0 based, this row will be included
	int iPartialR2;					//partial reading end row number, this row will not be included
	int iRenameWks;					//if rename worksheet name to the file name
	int iBigEndian;					//numeric value byte order, use big endian if TRUE
	int iApplyRange;				//
	int iMode;						// Data destination in worksheet. See ASCIMP_MODE_* constants in OC_Types.h
	/// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
	int iSkipRows;					// number of data rows to skip for each row of data read
	/// end ADD_SKIPROWS_TO_BINIMP
	/// EJP 09-12-2003 v7.5693 QA70-5073 ADD_READROWS_TO_BINIMP
	int iReadRows;
	/// end ADD_READROWS_TO_BINIMP
	vector<BYTE> vParamType;		//data type for each column
	vector<WORD> vParamSize;		//size of the data type for each column, bytes
	vector<WORD> vParamCount;		//number of consective columns with same data type
	DWORD flags; /// EJP 07-21-2004 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
} BINIMP;
*/
///END REMOVE_TO_OC_TYPE
enum {
	BIN_SUCCEED = 0,				// the import succeeded
	BIN_INVALID_ARGUMENT,			// invalid argument passed to the fucntion
	BIN_OPEN_FILE_FAILURE,			// fail to open the binary data file
	BIN_FAIL_INIT_WKS,				// fail to intialize the worksheet
	BIN_FAIL_RENAME_WKS,			// fail to rename the worksheet
	BIN_INVALID_TYPE,				// invalid data type found in the BINIMP struct 
	BIN_INVALID_SIZE				// invalid data element size
};

//#define IMPORT_FILTER_BINIMP					"BINIMP"

#define IS_TYPE_REAL(_type)  	(_type == BIP_TYPE_REAL)
#define IS_TYPE_INT(_type)	 	(_type == BIP_TYPE_INT)
#define IS_TYPE_UINT(_type)	 	(_type == BIP_TYPE_UINT)
#define IS_TYPE_STRING(_type)	(_type == BIP_TYPE_STRING)

BOOL fuGetBINIMP(TreeNode& trFilter, BINIMP& binimp, BOOL bGetCommonNode=FALSE);

// IWUser
typedef int (*PFNIMPLAYERFUNC)(Layer &lyTarget, TreeNode &trFilter, LPCSTR lpcszFile, int iFile);
typedef int (*PFNIMPORTFUNC)(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int iFile);
PFNIMPLAYERFUNC fuGetImportToLayerFunctionPtr(TreeNode &trFilter);
PFNIMPORTFUNC fuGetImportFunctionPtr(TreeNode &trFilter);

// IWXF
///---Sim 08-29-2006 GET_FILTER_BY_ID
BOOL fuGetXFunction(TreeNode& tnFilter, TreeNode& tnXFunc);
//BOOL fuGetXFunctionName(TreeNode& tnFilter, string& strName);
#define fuGetXFunctionName(_tnFilter, _strName)		fuGetRStr(_tnFilter, IDE_XFIMP_NAME, _strName)
///---END GET_FILTER_BY_ID

// Addition

///---Sim 09-04-2006 REMOVE_FROM_FILTER_UTILS
#define IMPORT_FILTER_DISPIMP					"Display"
#define IMPORT_FILTER_ASCIMP					"ASCIMP"
#define IMPORT_FILTER_BINIMP					"BINIMP"
#define IMPORT_FILTER_USERDEFIMP				"UserDefine"
#define IMPORT_FILTER_XFIMP						"XFunction"

/**
		Write an ASCIMP structure into the ASCIMP node of a filter.
	Parameters:
		trFilter = target filter
		ascimp = source ASCIMP structure
		bSetCommonNode = TRUE to also set the Common node
*/
void fuSetASCIMP(TreeNode& trFilter, ASCIMP& ascimp, BOOL bSetCommonNode=FALSE);

/**
		Read a filter's BINIMP node into an BINIMP structure.
	Parameters:
		trFilter = source filter
		binimp = target BINIMP structure
		bGetCommonNode = TRUE to update structure's common settings from Common node
*/
//BOOL fuGetBINIMP(TreeNode& trFilter, BINIMP& binimp, BOOL bGetCommonNode=FALSE); ///---Sim 08-17-2006 REMOVE_TO_FU_UTILS

/**
		Write an BINIMP structure into the BINIMP node of a filter.
	Parameters:
		trFilter = target filter
		binimp = source BINIMP structure
		bSetCommonNode = TRUE to also set the Common node
*/
void fuSetBINIMP(TreeNode& trFilter, BINIMP& binimp, BOOL bSetCommonNode=FALSE);
///Hong 8/30/06 CREATE_FILTER_BY_STRUCTRE
/**
		Write an DISIMP structure into the Display node of a filter.
	Parameters:
		trFilter = target filter
		disimp = source DISIMP structure
*/
void fuSetDISPIMP(TreeNode& trFilter, DISPIMP& dispimp);
/**
		Write an XFIMP structure into the XFunction node of a filter.
	Parameters:
		trFilter = target filter
		xfimp = source XFIMP structure
*/
void fuSetXFIMP(TreeNode& trFilter, XFIMP& xfimp);
/**
		Write an USERDEFIMP structure into the UserDefine node of a filter.
	Parameters:
		trFilter = target filter
		userdefimp = source USERDEFIMP structure
*/
void fuSetUSERDEFIMP(TreeNode& trFilter, USERDEFIMP& userdefimp);

void fuPrepareDefault(TreeNode& trFilter, int nFilterType);
///---END REMOVE_FROM_FILTER_UTILS

///---Sim 02-05-2007 MORE_WORK_ON_TEMPLATE
enum{
	TEMPL_BOOK		= 1,
	TEMPL_SHEET		= 2,
};

enum{
	TEMPL_TYPE_UNKNOWN	= 0,
	TEMPL_TYPE_OTW,
	TEMPL_TYPE_OTM,
	TEMPL_TYPE_OGW,
	TEMPL_TYPE_OGM,
};
int check_template(string& strTemplate, int nType = TEMPL_BOOK);
///---END MORE_WORK_ON_TEMPLATE

/// AW 08/30/06 SUPPORT_MULTI_FILES_INXF
///---Sim 09-19-2006 SUPPORT_DATA_RANGE
//Layer GetTargetLayer(Page& pgTarget, int& nIndexLayer, int nIndexFile, TreeNode& trFilter, BOOL bSameFilter = true); 
Layer GetTargetLayer(Page& pgTarget, int& nIndexLayer, int nIndexFile, TreeNode& trFilter, BOOL bSameFilter = true, DataRange& orng = NULL, int nDefaultMode = ASCIMP_MODE_NEW_SHEETS, int& nC1 = NULL, bool bShowTimeCol = true, int& nC2 = NULL, string& strDataFilePath = NULL);
///---END SUPPORT_DATA_RANGE
void GetDataRange(Layer& lyTarget, DataRange& dr, int nImportMode );
/// END SUPPORT_MULTI_FILES_INXF
/// Hong 9/01/06 CONVERT_75_FILTER_TO_80
void GetDispFilter(const TreeNode &trIn, TreeNode &trOut);
void SettingFilterID(const TreeNode &tr);
bool ConvFilter(const TreeNode &trFilterOlder, TreeNode &trFilterLater);
///  CONVERT_75_FILTER_TO_80

///---Sim 09-06-2006 ADD_NODE_DYNAMIC
#define FILTER_ADD_NODE(_trFilter, _ID, _TAGNAME) \
	if ( !tree_get_node_by_id(_trFilter, _ID, true) ) \
	{ \
		TreeNode _tn = _trFilter.AddNode(_TAGNAME); \
		_tn.SetAttribute(STR_DATAID_ATTRIB, _ID); \
	}
///---END ADD_NODE_DYNAMIC

// filter_utils

/// EJP 08-10-2004 v8.0115 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
#if _OC_VER >= 0x0800
#include <..\originlab\ImportFileBase.h>
#endif // _OC_VER >= 0x0800
/// end IMPORT_INFO_STORAGE_CLEANUP

#include <oFilterUtils.h> /// EJP 2006-02-28 v8.0369 MOVE_OC_FILTER_UTILS_TO_VC

///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
/// Hong 08/15/07 v8.0682 PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING
// move to oc_sys.h for more general place
//#define	IMPORT_FILTER_EXTENSION					"oif" 
/// end PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING
//#define	IMPORT_FILTER_EXTENSION_WILD			"*.oif"

#define IMPORT_FILTER_APPLICABILITY				"APPLICABILITY"

#define IMPORT_FILTER_PLOT_TEMPLATE				"PLOT_TEMPLATE"
#define IMPORT_FILTER_PLOT_ID					"PLOT_ID"
#define IMPORT_FILTER_BINARY					"BINARY"

#define IMPORT_FILTER_DESIGNATIONS				"DESIGNATIONS"
#define IMPORT_FILTER_FORMATS					"FORMATS"
#define	IMPORT_FILTER_REPETITIVE				"REPETITIVE"
//#define	FILTERS_FOLDER_NAME						"Filters\\"
///---END REMOVE_TO_FU_UTILS

#define FILTER_ASCII_OCFILE			"OriginLab\\FileImport.c"
/// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
///#define FILTER_ASCII_OCFUNCTION		"ImportASCII"
#define FILTER_ASCII_OCFUNCTION		"ImportAsciiToLayer"
/// end PRESERVE_ACTIVE_PAGE_AND_LAYER

#define FILTER_BINARY_OCFILE		"OriginLab\\FileImport.c"
#define FILTER_BINARY_OCFUNCTION	"ImportBinary"

/// EJP 08-13-2004 v8.0117 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
#define FILTER_OCCLASS_NAME					"OCClass"
#define FILTER_OCFUNC_NAME					"OCFunction"
/// end IMPORT_INFO_STORAGE_CLEANUP

enum {
	FILTER_PATH_DATA = 0,
	FILTER_PATH_ORIGIN,
	FILTER_PATH_USER,
	FILTER_PATH_GROUP,	/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP	
};
//#define IS_FILTER_PATH_ID(_i) (FILTER_PATH_DATA <= (_i) && (_i) <= FILTER_PATH_USER)
#define IS_FILTER_PATH_ID(_i) (FILTER_PATH_DATA <= (_i) && (_i) <= FILTER_PATH_GROUP) /// Hong 09/26/07 v8.0709 FIX_GROUP_FOLDER_FILTER_NOT_WORK

///---Sim 08-30-2006 GET_FILTER_BY_ID
//bool fuGetUserDefinedFunction(TreeNode &trFilter, string &strOCFile, string &strOCFunction);
#define fuGetUserDefinedFunction(_tn, _strOCFile, _strOCFunction) \
	( fuGetRStr(_tn, IDE_IMP_FILE, _strOCFile) && fuGetRStr(_tn, IDE_IMP_FUNCTION, _strOCFunction) )
bool fuSetUserDefinedFunction(TreeNode &trFilter, LPCSTR lpcszOCFile, LPCSTR lpcszOCFunction);
//#define fuSetUserDefinedFunction(_tn, _lpcszOCFile, _lpcszOCFunction) \
	( fuSetStr(_tn, IDE_IMP_FILE, _lpcszOCFile) && fuSetStr(_tn, IDE_IMP_FUNCTION, _lpcszOCFunction) )
///---END GET_FILTER_BY_ID

#define fuSetRenameWks(_tn, _nVal)					fuSetInt(_tn, IDE_IMP_RENAMEWKS, _nVal)
#define fuIsAppendFileNameToColumnComments(_tn)		fuGetFlag(_tn, AI_FLAG_FNAME_TO_COL_COMMENTS, FALSE)
#define fuSetAppendFileNameToColumnComments(_tn, _bVal)		fuSetFlag(_tn, AI_FLAG_FNAME_TO_COL_COMMENTS, _bVal) ///---Sim 01-29-2007 MORE_UTILS_FUNCTION
///---Sim 01-29-2007 MORE_UTILS_FUNCTION
#define fuXFIsAppendFileNameToColumnComments(_tn)		fuGetInt(_tn, IDE_IMP_FILENAME2COLCOMMENT, FALSE)
#define fuXFSetAppendFileNameToColumnComments(_tn, _bVal)		fuSetInt(_tn, IDE_IMP_FILENAME2COLCOMMENT, _bVal)
///---END MORE_UTILS_FUNCTION
/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
BOOL fuGetAddRoot(TreeNode& trFilter, TreeNode& trAddsRoot);

#define fuSetRenameWksWithVar(_tn, _bVal)		fuSetFlag(_tn, AI_FLAG_VARIABLE_TO_WKS_NAME, _bVal)
#define fuIsRenameWksWithVar(_tn)				fuGetFlag(_tn, AI_FLAG_VARIABLE_TO_WKS_NAME, FALSE)
BOOL fuSetRenameWksVarName(TreeNode &trFilter, LPCSTR lpcszVarName);
BOOL fuGetRenameWksVarName(TreeNode &trFilter, string& strVarName);
/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
#define fuSetRenameWkbkWithVar(_tn, _bVal)		fuSetFlag(_tn, AI_FLAG_VARIABLE_TO_WKBK_NAME, _bVal)
#define fuIsRenameWkbkWithVar(_tn)				fuGetFlag(_tn, AI_FLAG_VARIABLE_TO_WKBK_NAME, FALSE)
BOOL fuSetRenameWkbkVarName(TreeNode &trFilter, LPCSTR lpcszVarName);
BOOL fuGetRenameWkbkVarName(TreeNode &trFilter, string& strVarName);
///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF

/// Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE
#define fuSetForceSameSize(_tn, _bVal)			fuSetFlag(_tn, AI_FLAG_ADD_NANUM_MAKE_SAME_LENGTH, _bVal)
#define fuIsForceSameSize(_tn)					fuGetFlag(_tn, AI_FLAG_ADD_NANUM_MAKE_SAME_LENGTH, TRUE)
/// end ADD_FORCE_ROW_SAME_SIZE

/// Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
#define fuSetKeepTargetColFormat(_tn, _bVal)			fuSetFlag(_tn, AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT, _bVal)
#define fuIsKeepTargetColFormat(_tn)					fuGetFlag(_tn, AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT, FALSE)
/// end MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT

/// Hong 12/05/07 v8.0761 IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA
#define fuSetAllowAllTextData(_tn, _bVal)			fuSetInt(_tn, IDE_ASCIMP_ALLOWALLTEXT, _bVal)
#define fuIsAllowAllTextData(_tn)					fuGetInt(_tn, IDE_ASCIMP_ALLOWALLTEXT, FALSE)
/// end IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA

/// Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST
#define fuGetShowFilterInOpenList(_tn)			fuGetInt(_tn, IDE_DISPIMP_SHOWFILTERINOPENLIST, 0)
#define fuSetShowFilterInOpenList(_tn, _nVal)	fuSetInt(_tn, IDE_DISPIMP_SHOWFILTERINOPENLIST, _nVal)
/// end FILTER_SHOW_IN_FILE_OPEN_LIST
 
///---Sim 03-08-2007 MORE_UTILS_FUNCTION
#define fuGetWksTrimFrom(_tn)		fuGetInt(_tn, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, 1)
#define fuGetWksTrimTo(_tn)			fuGetInt(_tn, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, 0)
#define fuGetWkBkTrimFrom(_tn)		fuGetInt(_tn, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, 1)
#define fuGetWkBkTrimTo(_tn)		fuGetInt(_tn, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, 0)

#define fuSetWksTrimFrom(_tn, _nVal)	fuSetInt(_tn, IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM, _nVal)
#define fuSetWksTrimTo(_tn, _nVal)		fuSetInt(_tn, IDE_DISPIMP_RENAMEWKSTRIMFNAMETO, _nVal)
#define fuSetWkBkTrimFrom(_tn, _nVal)	fuSetInt(_tn, IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM, _nVal)
#define fuSetWkBkTrimTo(_tn, _nVal)		fuSetInt(_tn, IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO, _nVal)
///---END MORE_UTILS_FUNCTION

///---Sim 02-28-2007 QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
#define fuGetPartialImport(_tn)		fuGetInt(_tn, IDE_XFIMP_PARTIAL_IMPORT, 0) ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
#define fuGetReadPoint(_tn)			fuGetInt(_tn, IDE_XFIMP_READ_POINT, 1)
#define fuGetSkipPoint(_tn)			fuGetInt(_tn, IDE_XFIMP_SKIP_POINT, 0)
//#define fuGetSubRange(_tn)			fuGetInt(_tn, IDE_XFIMP_SUB_RANGE, 0) ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
#define fuGetStartPoint(_tn)		fuGetInt(_tn, IDE_XFIMP_START_POINT, 1)
#define fuGetEndPoint(_tn)			fuGetInt(_tn, IDE_XFIMP_END_POINT, 0)

/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
#define fuGetStartTime(_tn)			fuGetDouble(_tn, IDE_XFIMP_START_TIME, 0)
#define fuGetEndTime(_tn)			fuGetDouble(_tn, IDE_XFIMP_END_TIME, -1)
/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT


///---Sim 03-19-2007 ADD_OPTION_TO_PARTIAL_COLUMN
#define fuGetColStartPoint(_tn)		fuGetInt(_tn, IDE_XFIMP_COL_START_POINT, 1) 
#define fuGetColEndPoint(_tn)			fuGetInt(_tn, IDE_XFIMP_COL_END_POINT, 0)
///---END ADD_OPTION_TO_PARTIAL_COLUMN

#define fuSetPartialImport(_tn, _nVal)	fuSetInt(_tn, IDE_XFIMP_PARTIAL_IMPORT, _nVal) ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
#define fuSetReadPoint(_tn, _nVal)		fuSetInt(_tn, IDE_XFIMP_READ_POINT, _nVal)
#define fuSetSkipPoint(_tn, _nVal)		fuSetInt(_tn, IDE_XFIMP_SKIP_POINT, _nVal)
//#define fuSetSubRange(_tn)				fuSetInt(_tn, IDE_XFIMP_SUB_RANGE, _nVal) ///---Sim 03-17-2007 ADD_OPTION_TO_DISABLE_PARTIAL_RANGE
#define fuSetStartPoint(_tn, _nVal)		fuSetInt(_tn, IDE_XFIMP_START_POINT, _nVal)
#define fuSetEndPoint(_tn, _nVal)		fuSetInt(_tn, IDE_XFIMP_END_POINT, _nVal)


/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
#define fuSetStartTime(_tn, _dVal)		fuSetDouble(_tn, IDE_XFIMP_START_TIME, _dVal)
#define fuSetEndTime(_tn, _dVal)		fuSetDouble(_tn, IDE_XFIMP_END_TIME, _dVal)
/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT

///---Sim 03-19-2007 ADD_OPTION_TO_PARTIAL_COLUMN
#define fuSetColStartPoint(_tn, _nVal)		fuSetInt(_tn, IDE_XFIMP_COL_START_POINT, _nVal)
#define fuSetColEndPoint(_tn, _nVal)		fuSetInt(_tn, IDE_XFIMP_COL_END_POINT, _nVal)
///---END ADD_OPTION_TO_PARTIAL_COLUMN
///---END QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS

/// AW 08/18/06 SUPPORT_XF_OPTION_SETTING
// I did not use the first way as it need change VC level
#define fuSetXFSetting(_tn, _nVal)			fuSetInt(_tn, IDE_XFIMP_OPENSETTING, _nVal)	
/// END SUPPORT_XF_OPTION_SETTING

#define fuSetApplyRangeToGraph(_tn, _nVal)	fuSetInt(_tn, IDE_DISP_IMP_RANGETOGRAPH, _nVal)

#define fuSetPlotTemplate(_tn, _lpcstr)		fuSetStr(_tn, IDE_DISP_IMP_PLOTTEMPLATE, _lpcstr)

#define fuIsFileNameToWksLabel(_tn)				fuGetInt(_tn, IDE_DISP_IMP_FNAMETOWKSLAB, TRUE)
#define fuSetFileNameToWksLabel(_tn, _nVal)		fuSetInt(_tn, IDE_DISP_IMP_FNAMETOWKSLAB, _nVal)

#define fuGetDescription(_tn, _strVal)		fuGetRStr(_tn, IDE_DISP_IMP_DESCRIPTION, _strVal)
#define fuSetDescription(_tn, _lpcstr)		fuSetStr(_tn, IDE_DISP_IMP_DESCRIPTION, _lpcstr)

#define fuGetApplicability(_tn)					fuGetStr(_tn, IDE_DISP_IMP_FILESPEC, "")
#define fuGetPlotTemplate(_tn)					fuGetStr(_tn, IDE_DISP_IMP_PLOTTEMPLATE, "")

int fuGetDragDropGraph(TreeNode& trFilter);
void fuSetDragDropGraph(TreeNode& trFilter, int iMode);

int fuGetDragDropWorkspace(TreeNode& trFilter);
void fuSetDragDropWorkspace(TreeNode& trFilter, int iMode);

Page fuCreateTargetPage(TreeNode& trFilter, int iOption = CREATE_VISIBLE);

void fuGetFilterFiles(StringArray& sarrFilterFiles, LPCSTR lpcszFolderPath, LPCSTR lpcszDataFile = NULL, int iFilterType = FILTER_TYPE_IGNORE);

void fuGetFilterFiles(StringArray &saFilterFiles, int iFilterType = FILTER_TYPE_IGNORE, LPCSTR lpcszDataFile = NULL);

void fuAppendFilterFiles(StringArray& sarrFilterFiles, LPCSTR lpcszFolderPath, LPCSTR lpcszDataFile = NULL, int iFilterType = FILTER_TYPE_IGNORE);

void fuGetFilterList(StringArray &saFilterList, StringArray &saFilterFiles);

///------ Folger 04/30/09 SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL
#define SZ_IW_NONE					_L("<None>")
#define SZ_IW_PAGE_FILTER			_L("<Use filter in active window>")

void fuGetFilterListForImportWizard(StringArray &saFilterList, int iFilterType = FILTER_TYPE_IGNORE, LPCSTR lpcszDataFile = NULL, bool bAddPageFilter = false, vector<string>* pvsFilterFiles = NULL);
///------ End SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL

BOOL fuGetFilterFileNameFromListItem(LPCSTR lpcszFilterListItem, String &strFileName, LPCSTR lpcszDataPath=NULL);


void fuPrepareDefault(TreeNode& trFilter, int nFilterType);//Hong 8/30/06 CREATE_FILTER_BY_STRUCTRE


BOOL fuIsApplicable(LPCSTR lpcszFilterFile, LPCSTR lpcszDataFile, int iFilterType=FILTER_TYPE_IGNORE);
BOOL fuIsApplicable(TreeNode &trFilter, LPCSTR lpcszDataFile, int iFilterType=FILTER_TYPE_IGNORE);


BOOL fuRemoveHeaderParams(TreeNode &trFilter);
bool fuGetHeaderParamDefined(TreeNode &trFilter, int &nVal);
void fuSetHeaderParamDefined(TreeNode &trFilter, int nVal);
TreeNode fuGetHeaderParams(TreeNode &trFilter);
bool fuGetHeaderParamNames(TreeNode &trFilter, StringArray &saNames);
int fuGetHeaderParamCount(TreeNode &trFilter);

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
/// EJP 09-30-2004 QA70-5658 v8.0142 IMPROVE_HDRVAR_EXTRACTION
#define FLT_VAR_DELIMITER		0x00000001
#define FLT_VAR_POSITION		0x00000002
#define FLT_VAR_FILENAME		0x00000004
#define FLT_VAR_HEADER			0x00000008

enum {
	FLT_HDRVAR_NONE = 0, // no header variables
	FLT_HDRVAR_AUTO, // scan according to a specified delimiter
	FLT_HDRVAR_SPECIFY, // user specifies unique position and delimiter for each variable name and value
	FLT_HDRVAR_OCFUNC // call a user defined Origin C function
};

BOOL fuGetVar(TreeNode& tnFilter, TreeNode& tnVar, int nIndex);
BOOL fuGetVars(TreeNode& tnFilter, TreeNode& tnVars);

BOOL fuAddHdrVar(TreeNode& tnFilter, TreeNode& tnHdrVar);
BOOL fuDelHdrVar(TreeNode& tnFilter, int nIndex);

#define fuIsExtractVarByDelimiter(_tn)	fuGetInt(_tn, IDE_VARIMP_EXTBYDELIMITER, FALSE)
/// Hong 9/15/06 FIX_TREE_NODE_NOT_EXIST
//#define fuSetExtractVarByDelimiter(_tn, _bEnable)	fuSetInt(_tn, IDE_VARIMP_EXTBYDELIMITER, _bEnable)
BOOL fuSetExtractVarByDelimiter(TreeNode& tnFilter, BOOL bEnable);
/// end FIX_TREE_NODE_NOT_EXIST
#define fuIsExtractVarByPosition(_tn)	fuGetInt(_tn, IDE_VARIMP_EXTBYPOSITION, FALSE)
/// Hong 9/15/06 FIX_TREE_NODE_NOT_EXIST
//#define fuSetExtractVarByPosition(_tn, _bEnable)	fuSetInt(_tn, IDE_VARIMP_EXTBYPOSITION, _bEnable)
BOOL fuSetExtractVarByPosition(TreeNode& tnFilter, BOOL bEnable);
/// end FIX_TREE_NODE_NOT_EXIST
#define fuIsExtractVarByScanning(_tn)	fuGetInt(_tn, IDE_VARIMP_EXTVARBYSCAN, FALSE)

#define fuIsExtractVarByOCFunc(_tn)		fuGetInt(_tn, IDE_VARIMP_EXTBYOCFUNC, FALSE)
/// Hong 9/15/06 FIX_TREE_NODE_NOT_EXIST
//#define fuSetExtractVarByOCFunc(_tn, _bEnable)		fuSetInt(_tn, IDE_VARIMP_EXTBYOCFUNC, _bEnable)
BOOL fuSetExtractVarByOCFunc(TreeNode& tnFilter, BOOL bEnable);
/// end FIX_TREE_NODE_NOT_EXIST

BOOL fuGetExtractVarOCFunc(TreeNode& tnFilter, String& strFileName, String& strFuncName);
BOOL fuSetExtractVarOCFunc(TreeNode& tnFilter, LPCSTR lpcszFileName, LPCSTR lpcszFuncName);
typedef int (*PFNHDRVARFUNC)(StringArray& saVarNames, StringArray& saVarValues, const StringArray& saHdrLines, const TreeNode &trFilter);
PFNHDRVARFUNC fuGetExtractVarOCFuncPtr(TreeNode& tnFilter);

/// SY 01/07/2005 v8.0184 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
/// Hong 01/15/07 FIX_TREE_NODE_NOT_EXIST
//#define fuSetVarInPageInfo(_tn, _bEnable)	fuSetInt(_tn, IDE_VARIMP_PAGEINFO, _bEnable)
BOOL fuSetVarInPageInfo(TreeNode& tnFilter, BOOL bEnable);
/// end FIX_TREE_NODE_NOT_EXIST
/// end IMPORT_INFO_STORAGE_CLEANUP
/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
BOOL 	fuSetVarInUDL(TreeNode& tnFilter, BOOL bEnable);
#define	fuIsVarInUDL(_tn)						fuGetInt(_tn, IDE_VARIMP_USERDEFINEDPARAM, FALSE)
/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS

/// end IMPROVE_HDRVAR_EXTRACTION
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

TreeNode fuGetHeaderParam(TreeNode &trFilter, LPCSTR lpcszName);
bool fuGetHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int &nType, int &n1, int &n2, int &n3);
bool fuGetASCHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int &nType, int &nLine, int &nPos, int &nEnd);
bool fuGetBinHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int &nType, int &nOffset, int &nSize);

bool fuAddHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int nType=0, int n1=0, int n2=0, int n3=0);
bool fuAddASCHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int nType, int nLine, int nPos, int nEnd);
bool fuAddBinHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int nType, int nOffset, int nSize);

bool fuGetHdrVarScan(TreeNode &trFilter, int &iFirstLine, int &iLastLine, int &iSeparator);
bool fuSetHdrVarScan(TreeNode &trFilter, int iFirstLine, int iLastLine, int iSeparator);

bool fuGetHdrSave(TreeNode &trFilter, int &iFirstLine, int &iNumLines);
bool fuSetHdrSave(TreeNode &trFilter, int iFirstLine, int iNumLines);

bool fuGetFileSpec(TreeNode &trFilter, string &strFileSpec);
#define fuSetFileSpec(_tn, _lpcstr)			fuSetStr(_tn, IDE_DISP_IMP_FILESPEC, _lpcstr)

bool fuGetFilesOfTypeGroupName(TreeNode &trFilter, string &strName);
bool fuSetFilesOfTypeGroupName(TreeNode &trFilter, LPCSTR lpcstrName);
bool fuGetFilesOfType(TreeNode &trFilter, StringArray &saFileSpecNames);
bool fuSetFilesOfType(TreeNode &trFilter, StringArray &saFileSpecNames);

/// Hong 9/25/06 FIX_SCRIPT_FAIL_TO_WORK_IN_IMPORTWIZARD
/*
/// EJP 07-07-2003 v7.0619 QA70-4783 POST_IMPORT_EXECUTE
#define fuSetPostImportScript(_tn, _lpcstr)		fuSetStr(_tn, IDE_IMP_POSTIMPSCRIPT, _lpcstr)
/// end POST_IMPORT_EXECUTE
*/
bool fuSetPostImportScript(TreeNode &trFilter, string strScript);
/// END FIX_SCRIPT_FAIL_TO_WORK_IN_IMPORTWIZARD

/// EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
bool fuSaveFilterToPage(TreeNode &trFilter, Page &pgTarget);
bool fuLoadFilterFromPage(TreeNode &trFilter, Page &pgTarget, int iType);
bool fuIsFilterInPage(Page &pgTarget, int iType, LPCSTR lpcszDataFile=NULL);
bool fuIsOneFilterInPage(Page &pgTarget, LPCSTR lpcszDataFile, int &iFilterType);
/// end SAVE_FILTER_IN_WKS

/// EJP 09-09-2003 v7.5689 QA70-4818 UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS
bool fuUpdatePageASCIMP(Page &pg, bool bUpdateInternal);
typedef bool (*PFNUPDATEPGASCIMP)(Page &pg, bool bUpdateInternal);
/// end UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS

bool fuSave(TreeNode &trFilter, LPCSTR lpcszFile);

/// EJP 08-10-2004 v8.0115 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
#if _OC_VER >= 0x0800
///---Sim 08-30-2006 GET_FILTER_BY_ID
//bool fuGetUserDefinedClass(TreeNode &trFilter, string &strOCFile, string &strOCClass);
#define fuGetUserDefinedClass(_tn, _strOCFile, _strOCClass) \
	( fuGetRStr(_tn, IDE_IMP_FILE, _strOCFile) && fuGetRStr(_tn, IDE_IMP_CLASS, _strOCClass) )
bool fuSetUserDefinedClass(TreeNode &trFilter, LPCSTR lpcszOCFile, LPCSTR lpcszOCClass);
//#define fuSetUserDefinedClass(_tn, _lpcszOCFile, _lpcszOCClass) \
	( fuSetStr(_tn, IDE_IMP_FILE, _lpcszOCFile) && fuSetStr(_tn, IDE_IMP_CLASS, _lpcszOCClass) )
///---END GET_FILTER_BY_ID
ClassObject& fuGetImportClassRef(TreeNode& trFilter, LPCSTR lpcszOCClass, LPCSTR lpcszOCFile);
#endif // _OC_VER >= 0x0800
/// end IMPORT_INFO_STORAGE_CLEANUP

/// EJP 11-03-2004 v8.0159 QA70-6554 EXTRACT_VARS_FROM_FILENAME
BOOL fuGetHdrLines(TreeNode& tnFilter, StringArray& saHdrLines, LPCSTR lpcszFileName);
/// end EXTRACT_VARS_FROM_FILENAME

/// EJP 2005-08-16 v8.0289 QA70-7996 IMPWIZ_SUPPORT_XFUNC
#define fuSetXFunctionName(_tn, _lpcstr)		fuSetStr(_tn, IDE_XFIMP_NAME, _lpcstr)
BOOL fuGetXFunctionOptions(TreeNode& tnFilter, TreeNode& tnOptions);
BOOL fuSetXFunctionOptions(TreeNode& tnFilter, TreeNode& tnOptions);
/// end IMPWIZ_SUPPORT_XFUNC
/// Hong 9/14/06 REMOVE_IMPORT_RELATED_TO_FU_UTILS
/// EJP 2006-07-07 v8.0440 QA70-8697 XFUNC_BASED_IMPORT, Move code to here from FileImport.c
#if _OC_VER >= 0x0800
//bool impinfo_InitTree(Page& pgTarget, int nImportMode);
bool impinfo_InitTree(Page& pgTarget, int nImportMode, bool bCleanReadOnly = true); /// Hong 02/12/07 MAKE_READONLY_FOR_FILE_BINARY_STORAGE
bool impinfo_GetLastFileNode(Page& pgSource, TreeNode& trTarget);
//bool impinfo_SetLastFileNode(Page& pgTarget, TreeNode& trFile);/// AW 09/28/06 QA80-9010 GET_VARIABLE_VALUE_FROM_ORGANIZER
bool impinfo_FilterNameToLastFileNode(Page& pgTarget, LPCSTR lpcszFilterFile);
/// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
//int impinfo_HeaderVariablesToFileNode(TreeNode& tnFile, const StringArray& saVarNames, const StringArray& saVarValues);
//int impinfo_FileNameVariablesToFileNode(TreeNode& tnFile, const StringArray& saVarNames, const StringArray& saVarValues);
int impinfo_HeaderVariablesToFileNode(TreeNode& tnFile, const StringArray& saVarNames, const StringArray& saVarValues, const StringArray* psaVarLabels = NULL);
int impinfo_FileNameVariablesToFileNode(TreeNode& tnFile, const StringArray& saVarNames, const StringArray& saVarValues, const StringArray* psaVarLabels = NULL);
/// end VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
///Hong 8/04/06 ADD_FILTER_INFO
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType);
/// AW 09/28/06 QA80-9010 GET_VARIABLE_VALUE_FROM_ORGANIZER
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter = NULL);
///---Sim 02-06-2007 ADD_RANGE_INFO_TO_BASE_INFO
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter = NULL, int& findex =NULL);
/// Hong 03/07/07 FIX_MULTI_ASC_INFINITE_LOOP
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter = NULL, int& findex =NULL, TreeNode& trRange = NULL);
/// Hong 03/12/07 QA80-9418-S1 ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter = NULL, int findex = 1, TreeNode& trRange = NULL);
/// AW 07/11/07 SHOULD_NOT_AUTO_SIZE_IN_EXCEL_IMPORT
enum
{
	IMP_INFO_ADDFILE_NO_AUTO_SIZE = 1,
};
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter = NULL, int findex = 1, TreeNode& trRange = NULL, bool bReimport = false);
bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter = NULL, int findex = 1, TreeNode& trRange = NULL, bool bReimport = false, DWORD dwOPtion = 0);
/// END SHOULD_NOT_AUTO_SIZE_IN_EXCEL_IMPORT
/// end ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
/// end FIX_MULTI_ASC_INFINITE_LOOP
///---END ADD_RANGE_INFO_TO_BASE_INFO
bool impinfo_SetLastFileNode(Page& pgTarget, TreeNode& trFile, int& findex =NULL);
/// END GET_VARIABLE_VALUE_FROM_ORGANIZER

/// Hong 03/12/07 QA80-9418-S1 ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
/**
		get the treenode in file binary storage by datarange
	Parameters:
		trFile = [output]file info tree
		dr = [input]DataRange to get file info
	Rreturn:
		index of trFile in File Binary Storage Tree, return -1 if not find
*/
/// Hong 05/30/07 OUTPUT_ERROR_CODE
//int getFileInfoByRange(TreeNode& trFile, const DataRange& dr);
int getFileInfoByRange(TreeNode& trFile, const DataRange& dr, int* nErrCode = NULL);
/// end OUTPUT_ERROR_CODE
bool impinfo_UpdateFileNode(Page& pgTarget, TreeNode& trFile, int nIndex);
/// end ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT

///end ADD_FILTER_INFO
///---Sim 02-14-2007 ADD_INFO_FOR_COVERED_DATA
void impinfo_UpdateCovered(TreeNode& trFile, bool bCovered);
bool impinfo_UpdateExistingData(Page& pgTarget, DataRange& drNewImported);
///---END ADD_INFO_FOR_COVERED_DATA
#endif // _OC_VER >= 0x0800
/// end XFUNC_BASED_IMPORT
/// end REMOVE_IMPORT_RELATED_TO_FU_UTILS

///Hong 9/26/06 MOVE_TO_FU_UTILS_AS_UTIL_FUNCTION
int GetFilterClassName(TreeNode& trFilter, string& strClassName);
/// END MOVE_TO_FU_UTILS_AS_UTIL_FUNCTION

///---Sim 01-29-2007 MORE_UTILS_FUNCTION
#define STR_RANGE_INFO_NODE	"FileDataRange"
#define STR_RANGE_STR		"Range"
//#define STR_RANGE_UID		"RangeUID" ///---Sim 11-01-2007 CLEAN_RANGE_ID_CODE remove

/// AW 05/02/07 QA80-9716 v8.0612 SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
#define STR_PARTIAL_DURATION_TIME			"Duration"
#define STR_PARTIAL_IMPORT_INTERVAL			"Interval"
#define STR_PARTIAL_START_TIME				"StartTime"
/// END SUPPORT_PCLAMP_TIME_PARTIAL_IMPORT
/// Hong 01/15/09 FIX_PCLAMP_PLOT_FAIL_HANDLE_TIME_OFFSET_OF_HOLDING_DURATION
#define	STR_HOLDING_DURATION				"HoldingDuration"
/// end FIX_PCLAMP_PLOT_FAIL_HANDLE_TIME_OFFSET_OF_HOLDING_DURATION

/// Hong 06/04/07 v8.0623 USE_MACRO_FOR_MORE_FRIENDLY_NAME
#define STR_FILTER_PARTIAL_NODE		"partial"   //#define STR_FILTER_PARTIAL_NODE		"parital"  //Justin 2007-06-14
#define STR_FILTER_FILENAME_NODE	"names"
/// end USE_MACRO_FOR_MORE_FRIENDLY_NAME

// return value = range UID
int getRangeInfo(TreeNode& trRange, Datasheet& ds, int nC1, int nC2 = -1, int nR1 = 0, int nR2 = -1);
int getRangeInfo(TreeNode& trRange, DataRange& dr);

bool fuDisableAllRename(TreeNode& trFilter, bool* pbRenameWks = NULL, bool* pbRenameWkBk = NULL, bool* pbAppendWkBkComm = NULL, bool* pbAppendColComm = NULL, bool* pbRenameWksWithVar = NULL, bool* pbRenameWkbkWithVar = NULL);
bool fuSetAllRename(TreeNode& trFilter, bool* pbRenameWks = NULL, bool* pbRenameWkBk = NULL, bool* pbAppendWkBkComm = NULL, bool* pbAppendColComm = NULL, bool* pbRenameWksWithVar = NULL, bool* pbRenameWkbkWithVar = NULL);

///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
//bool getRenameMode(const TreeNode& trFilter, bool* pbRenameWks, bool* pbIncludePathWhenRenameBook = NULL, bool* pbRenameWkBk = NULL, bool* pbIncludePath = NULL, bool* pbAppendWkBkComm = NULL, bool* pbAppendColComm = NULL, bool* pbRenameWksWithVar = NULL, bool* pbRenameWkbkWithVar = NULL);
bool getRenameMode(const TreeNode& trFilter, bool* pbRenameWks, bool* pbRenameWkBkLongNameOnly = NULL, bool* pbIncludePathWhenRenameBook = NULL, bool* pbRenameWkBk = NULL, bool* pbIncludePath = NULL, bool* pbAppendWkBkComm = NULL, bool* pbAppendColComm = NULL, bool* pbRenameWksWithVar = NULL, bool* pbRenameWkbkWithVar = NULL);
///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
//void getImportedRangeStringArray(Page& pg, vector<string>& saRange);
//void getImportedRanges(vector<UINT>& vuRanges, Page& pg); ///---Sim 11-01-2007 CLEAN_RANGE_ID_CODE remove
bool isImported(Layer& ly);
///---END MORE_UTILS_FUNCTION

///---Sim 01-31-2007 ADD_AUTO_RENAME
//void updataImportFileRangeInfo(Page& pg);

#define RENAME_WKS_WHEN_NEW_BOOKS_FOR_AUTO	0x0001
#define COVER_LAST_ADDED_COMMENT			0x0002 ///---Sim 03-20-2007 FIX_APPEND_COMMENT_WHEN_REIMPORT
// dwCtrl :[input]  RENAME_WKS_WHEN_NEW_BOOKS = for the case one file contain multi-sheet, it shall not rename sheet
//					COVER_LAST_ADDED_COMMENT = cover the last line of comments if it is same as what we want to add now
bool setPageAndLayerName(DataRange& drTarget, const string& strFullFileName, const TreeNode& trFilter, DWORD dwCtrl = 0);
///---END ADD_AUTO_RENAME

//// AW 09/29/06 QA80-9015 MORE_ON_IMPORT_SINGLE_ASCII_FILE
BOOL GetRangeInfo(Range& orng, Datasheet& lyTarget, Page& pgTarget, int& c1,int& c2);
//// END MORE_ON_IMPORT_SINGLE_ASCII_FILE

///---Sim 10-30-2006 ERROR_MESSAGE
/**
		Check whether file name is valid.
	Parameters:
		strFileName = [input] the file name list, separated by '\n'
		nFileIdx = [output] the index of first invalid file name on list, index is 1 offset
	Return:
		true if all file name are valid.
*/
bool is_valid_filename(const string &strFileName, int &nFileIdx);
///---END ERROR_MESSAGE

///---Sim 11-20-2006 SUPPORT_DND_OPEN_DIALOG
/**
		Check imported file name and pass out error message.
	Parameters:
		strFileName = [input] the file name list, separated by '\n'
		strErr = [output] error message
	Return:
		true if all file names are valid.
*/	
bool check_imported_file_name(const string& strFileName, string& strErr);
///---END SUPPORT_DND_OPEN_DIALOG

///---Sim 11-30-2006 CHECK_EXPORTED_FILE_NAME
/**
		Check exported file name and pass out error message.
	Parameters:
		strFileName = [input] the file name
		strErr = [output] error message
	Return:
		true if file name is valid.
*/	
bool check_exported_file_name(const string& strFileName, string& strErr);
///---END CHECK_EXPORTED_FILE_NAME

///---Sim 06-01-2007 CONSTRUCT_FILTER_OPTIONS_GUI_TREE
#define STRUCT_TO_TREE_BY_ID(_STRUCT, _TREE) \
	{ \
		Tree _trTemp; \
		_trTemp = _STRUCT; \
		tree_copy_values_by_id(_trTemp, _TREE); \
	}

#define TREE_TO_STRUCT_BY_ID(_TREE, _STRUCT) \
	{ \
		Tree _trTemp; \
		_trTemp = _STRUCT; \
		tree_copy_values_by_id(_TREE, _trTemp); \
		_STRUCT = _trTemp; \
	}

bool is_filter_gui_tree(TreeNode &trFilter);
	
void fuPrepareDefaultFilterGUITree(TreeNode& trFilterGUI, int nFilterType);
///---END CONSTRUCT_FILTER_OPTIONS_GUI_TREE

///---Sim 01-29-2007 GET_MOST_GENERAL_OPTIONS_FOR_XF
// general import mode list
enum {
	IW_FLAG_IMPMODE_AUTO 		= 0x0001,
	IW_FLAG_IMPMODE_REPLACE 	= 0x0002,
	IW_FLAG_IMPMODE_NEW_BOOKS	= 0x0004,
	IW_FLAG_IMPMODE_NEW_SHEETS	= 0x0008,
	IW_FLAG_IMPMODE_NEW_COLS	= 0x0010,
	IW_FLAG_IMPMODE_NEW_ROWS	= 0x0020,
	IW_FLAG_IMPMODE_NEW_OBJECTS	= 0x0040,	///Sophy 6/4/2010 ORG-220 IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
};

#define LIST_IMPORT_MODE_REPLACE_BOOK_SHEET_COLUMN		( IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS | IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS )
#define LIST_IMPORT_MODE_REPLACE_BOOK_SHEET				( IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS | IW_FLAG_IMPMODE_NEW_SHEETS )
#define LIST_IMPORT_MODE_BOOK_SHEET						( IW_FLAG_IMPMODE_NEW_BOOKS | IW_FLAG_IMPMODE_NEW_SHEETS )
#define	LIST_IMPORT_MODE_REPLACE_BOOK_SHEET_OBJECT		( IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS | IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_OBJECTS )	///Sophy 6/8/2010 ORG-220-S1 SUPPORT_APPEND_MATRIXOBJECT_OF_SAME_DIM_TO_EXISTING_SHEET
#define	LIST_IMPORT_MODE_BOOK_SHEET_OBJECT				( IW_FLAG_IMPMODE_NEW_BOOKS | IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_OBJECTS )	///Sophy 6/4/2010 ORG-220 IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
///---Sim 05-08-2007 REMOVE_REPLACE_OUT_OF_MULTI_FILE_IMPORT_MODE
#define LIST_IMPORT_MODE_BOOK_SHEET_COLUMN		( IW_FLAG_IMPMODE_NEW_BOOKS | IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS )
#define LIST_IMPORT_MODE_ALL		( IW_FLAG_IMPMODE_AUTO | IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS | IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS | IW_FLAG_IMPMODE_NEW_ROWS )
///---END REMOVE_REPLACE_OUT_OF_MULTI_FILE_IMPORT_MODE

string getImportModeListString(string &strMaping = NULL, DWORD dwCtrl = \
		IW_FLAG_IMPMODE_AUTO | IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS \
		 | IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS | IW_FLAG_IMPMODE_NEW_ROWS);

///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
//void getEnableValueForFileNameOptions(int nAutoRename, int nRenameWks, int nRenameWkbk, int nAppendComm, int nAppendCol, \
		//bool& bRenameWks, bool& bRenameWksPartial, \
		//bool& bRenameWkbk, bool& bRenameWkbkPartial, bool& bRenameWkbkIncludePath, \
		//bool& bAppendIncludePath);
void getEnableValueForFileNameOptions(int nAutoRename, int nRenameWks, int nRenameWkbk, int nAppendComm, int nAppendCol, \
		bool& bRenameWks, bool& bRenameWksPartial, \
		bool& bRenameWkbk, bool& bRenameWkbkPartial, bool& bRenameWkBkLnOnly, bool& bRenameWkbkIncludePath, \
		bool& bAppendIncludePath);
///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
///---END CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
		
void constructOptionsForXF(TreeNode& trOptions, bool bAutoRename = true, bool bImportMode = true, bool bSparkLine = false, bool bTimeCol = false, bool bTemplate = true, bool bSkipPoints = false, bool bColPartial = false, bool bReadRow = false, bool bTimePartial = false);
///---END GET_MOST_GENERAL_OPTIONS_FOR_XF
///---Sim 11-19-2008 QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION
#define FILTER_OPTIONS_AUTO_RENAME				0x0001
#define FILTER_OPTIONS_IMPORT_MODE				0x0002
#define FILTER_OPTIONS_SPARKLINE				0x0004
#define FILTER_OPTIONS_TIME_COL					0x0008
#define FILTER_OPTIONS_TEMPLATE					0x0010
#define FILTER_OPTIONS_SKIP_POINTS				0x0020
#define FILTER_OPTIONS_COL_PARTIAL				0x0040
#define FILTER_OPTIONS_READ_ROW					0x0080
#define FILTER_OPTIONS_TIME_PARTIAL				0x0100
#define FILTER_OPTIONS_AUTO_SIZE				0x0200

///---Sim 11-21-2008 FIX_OVERLOAD_PROTOTYPE_CAUSE_IMP_XF_BROKEN
//void constructOptionsForXF(TreeNode& trOptions, DWORD dwCntrl = FILTER_OPTIONS_AUTO_RENAME | FILTER_OPTIONS_IMPORT_MODE | FILTER_OPTIONS_TEMPLATE);
void constructOptionsForXF(TreeNode& trOptions, DWORD dwCntrl);
///---END FIX_OVERLOAD_PROTOTYPE_CAUSE_IMP_XF_BROKEN
///---END QA80-12604 ADD_AUTO_RESIZE_CELL_IMPORT_OPTION

///---Sim 02-27-2007 QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS
//int reduce_data(vectorbase& vb, int nSkip, int nBlockSize = 1, int nStart = 0, int nEnd = -1);
void reduce_data(Worksheet& wks, int nC1, int nC2, int nSkip, int nStart = 0, int nEnd = -1, int nBlockSize = 1);
void reduce_data(Worksheet& wks, int nC1, int nC2, TreeNode& trFilter);
///---END QA80-9391 IMPORT_FILE_SKIP_DATA_POINTS

///---Sim 04-06-2007 MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT
void initASCIMP(ASCIMP& ascimp);
///---END MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT

///---Sim 06-08-2007 DEFAULT_VALUE_FOR_BIN_IMPORT
void initBINIMP(BINIMP& binimp);
///---END DEFAULT_VALUE_FOR_BIN_IMPORT

///---Sim 04-30-2007 TEMP_FIX_IMPORT_MODE_FOR_SINGLE_FILE
enum
{
	FILE_TYPE_NONE = 0,
	FILE_TYPE_ASCII,
	FILE_TYPE_CSV,
	FILE_TYPE_WAV,
	FILE_TYPE_PCLAMP,
	FILE_TYPE_SPC,
	FILE_TYPE_MDF,
	FILE_TYPE_JNB,
	FILE_TYPE_DIADEM,
	FILE_TYPE_TDM,
	FILE_TYPE_NETCDF,
	FILE_TYPE_MNTB,
	FILE_TYPE_FAMOS,
	FILE_TYPE_SPE,
	FILE_TYPE_EP,
	FILE_TYPE_MAT,
	FILE_TYPE_KG,
	FILE_TYPE_JCAMP,
	FILE_TYPE_IMAGE,
	FILE_TYPE_EXCEL,
	FILE_TYPE_DT,// dcf and hpf
};

int get_first_file_import_mode(int nFileType = FILE_TYPE_NONE);

///---END TEMP_FIX_IMPORT_MODE_FOR_SINGLE_FILE

///---Sim 05-31-2007 IMPROVE_REIMPORT_CONTEXT_MENUE
bool isReimportable(TreeNode& trFileNode, string* pstrXFName = NULL);
///---END IMPROVE_REIMPORT_CONTEXT_MENUE

///---Sim 06-06-2007 CHANGE_FILTER_TAGNAME_ISSUE
int tree_whole_copy_values_by_id(const TreeNode& trSrc, TreeNode& trDest);
///---END CHANGE_FILTER_TAGNAME_ISSUE

///---Sim 06-07-2007 FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES
#define STR_XF_NAME_WAV 	"ImpWAV"
#define STR_XF_NAME_CSV 	"ImpCSV"
#define STR_XF_NAME_IMAGE 	"ImpImage"
#define STR_XF_NAME_EXCEL	"ImpExcel"
#define STR_XF_NAME_MATLAB 	"ImpMatlab"
#define STR_XF_NAME_PCLAMP 	"ImppClamp"
#define STR_XF_NAME_MDF 	"ImpMDF"
#define STR_XF_NAME_SPE		"ImpSPE"
#define STR_XF_NAME_SPC 	"ImpSPC"
#define STR_XF_NAME_TDM 	"ImpNITDM"
#define STR_XF_NAME_DIADEM 	"ImpNIDIAdem"
#define STR_XF_NAME_NETCDF 	"ImpNetCDF"
///Sophy 8/24/2009 ADD_FILTERS_FOR_CDF_NETCDFEX_HDF5
#define	STR_XF_NAME_NETCDFEX	"ImpNetCDFEx"
#define	STR_XF_NAME_CDF		"ImpCDF"
#define	STR_XF_NAME_HDF5	"ImpHDF5"
///end ADD_FILTERS_FOR_CDF_NETCDFEX_HDF5
#define STR_XF_NAME_MNTB 	"ImpMNTB"
#define STR_XF_NAME_KG 		"ImpKG"
#define STR_XF_NAME_JNB 	"ImpJNB"
#define STR_XF_NAME_JCAMP 	"ImpJcamp"
#define STR_XF_NAME_FAMOS 	"ImpFamos"
#define STR_XF_NAME_EP 		"ImpEP"
#define STR_XF_NAME_DT 		"ImpDT"
#define STR_XF_NAME_IMP2DBIN 	"Impbin2d" ///---Sim 04-27-2010 ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK

bool isMultiFilesXF(LPCSTR lpcszXFName);
///---END FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES

/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
//bool is_drag_n_drop_supported(LPCSTR lpcszFilterName, bool bSystemFolder);/////---Jake 07/12/07 CHECK_SUPPORT_D&D
/**#
	nLocation = [input] spacify the location of filter, can be value in FILTER_LOCATION
*/
bool is_drag_n_drop_supported(LPCSTR lpcszFilterName, int nLocation);
/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP

///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
enum{
	SPARKLINE_NO_CHANGE = 0,
	SPARKLINE_ADD = 1,
	SPARKLINE_ADD_IF_LESS_THAN_50_COLS = 2,
};

#define STR_COMBO_SPARKLINE		_L("No|Yes|Yes(if less than 50 columns)")

bool update_sparkline(int nSparklineType, Worksheet& wks, int nC1 = 0, int nC2 = -1);
///---END SUPPORT_SMART_SPARKLINE
void update_sparkline_ex(int nSparklines, WorksheetPage pg);

/// Hong 09/08/07 v8.0698b FIX_FAIL_DUMP_OUTPUT_RANGE_ORNG
bool reset_range_to_first_obj(DataRange& dr, Datasheet& ds);
/// end FIX_FAIL_DUMP_OUTPUT_RANGE_ORNG

///Sophy 10/23/2008 QA80-12422 SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER

string fu_get_filter_path(int nLocalization = FILTER_LOCATION_SYSTEM_FOLDER);

bool	fuIsSysFilter( LPCSTR lpcszFilterFileName );
///end SUPPORT_D_N_D_USE_SHEET_THEME_IF_FILTER_FROM_SYSTEM_FOLDER

///---Sim 10-29-2008 v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING
#define STR_NODE_NAME_GETN_LT "GetNLT"
TreeNode check_add_getn_LT_to_filter_options(TreeNode& trOptions);
void	update_getn_LT_variables(TreeNode& trGetN, LPCSTR lpcszXFName, bool bGetN2FilterOptions);
///---END v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING
///---Sim 04-27-2010 ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK
void	generate_using_filter_tree_by_getn_tree(TreeNode& trUsingFilter, const TreeNode& trGetNOptions);
///---END ORG-29-P2 IMP_2D_BIN_SUPPORT_FILTER_SETTINGS_AND_SAVE_FILE_INFO_INTO_BOOK

///Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
void update_custom_date_format_combo_attrib(TreeNode& trDateFormat);		

#define EMPTY2NONE(_str) (0 == strlen(_str))? STR_NONE : (_str)
#define NONE2EMPTY(_str) compare_string_localization(_str, STR_NONE_E, true)? "" : (_str)
///End CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT

/// Hong 11/10/09 QA80-11771 IMPORT_MODE_SUPPORT_SKIP_EMPTY_BOOK_SHEET
bool	fuIsSkipEmptyBookSheet(int nImpMode);
/// end IMPORT_MODE_SUPPORT_SKIP_EMPTY_BOOK_SHEET

///---Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
void fu_autosize_rowcol(Worksheet wks, TreeNode& trFilter, double dminCol = -1, double dmaxCol = -1, double dminRow = -1, double dmaxRow = -1, int nColCounts = 0, DWORD dwCntrlCol = 0, DWORD dwCntrlRow = 0);
///---END QA81-14895 SPEED_UP_81_IMP_WIZ_ASC

///---Sim 02-04-2010 QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE
enum
{
	IMPORT_INFO_TO_USER_TREE = 0x0001,	
};
bool fu_set_import_file_name_info(OriginObject& obj, LPCSTR lpcszFileName, DWORD dwCtrl = 0);
bool fu_set_import_file_info(OriginObject& obj, TreeNode& trInfo, LPCSTR lpcszSectionName, DWORD dwCtrl = 0);
///---END QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE

///------ Folger 06/28/10 ORG-155 ASCII_IMPORT_SPEED_IMPROVE
TreeNode	fuCheckAddFileInfoNode(TreeNode& trFile, LPCSTR lpcszFile);
///------ End ASCII_IMPORT_SPEED_IMPROVE

#endif //_FU_UTILS_
